#include <bits/stdc++.h>
using namespace std;
using ll = long long;
const long long INF = (1LL<<62);

struct BITMin {
    int n;
    vector<long long> stablo;
    BITMin(int n=0){ init(n); }
    void init(int n_){
        n = n_;
        stablo.assign(n+1, (long long)INF);
    }
    void update(int i, long long val){
        for(; i<=n; i += i & -i)
            if (val < stablo[i]) stablo[i] = val;
    }
    long long upit(int i){
        long long rez = INF;
        for(; i>0; i -= i & -i)
            if (stablo[i] < rez) rez = stablo[i];
        return rez;
    }
};

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int n;
    if(!(cin>>n)) return 0;
    vector<long long> x(n), h(n);
    for(int i=0;i<n;++i) cin>>x[i];
    for(int i=0;i<n;++i) cin>>h[i];

    vector<int> indeksi(n);
    iota(indeksi.begin(), indeksi.end(), 0);
    sort(indeksi.begin(), indeksi.end(), [&](int a,int b){ return x[a] < x[b]; });

    vector<long long> xs(n), hs(n);
    vector<int> poz(n);
    for(int i=0;i<n;++i){
        xs[i] = x[indeksi[i]];
        hs[i] = h[indeksi[i]];
        poz[ indeksi[i] ] = i;
    }

    vector<int> po_visini(n);
    iota(po_visini.begin(), po_visini.end(), 0);
    sort(po_visini.begin(), po_visini.end(), [&](int a,int b){ return hs[a] > hs[b]; });

    vector<int> upiti(n);
    iota(upiti.begin(), upiti.end(), 0);
    sort(upiti.begin(), upiti.end(), [&](int a,int b){ return h[a] > h[b]; });

    BITMin bitLevo(n), bitDesno(n);
    bitLevo.init(n);
    bitDesno.init(n);

    vector<long long> odg(n, -1);
    int pokazivac = 0;

    for(int ui=0; ui<n; ++ui){
        int orig_i = upiti[ui];
        long long visina_i = h[orig_i];
        long long pozicija_x = x[orig_i];
        int p = poz[orig_i];

        while(pokazivac < n && hs[ po_visini[pokazivac] ] > visina_i){
            int j = po_visini[pokazivac];
            long long Aj = - xs[j] - hs[j];
            long long Bj =   xs[j] - hs[j];
            int idxL = j + 1;
            int idxD = n - j;
            bitLevo.update(idxL, Aj);
            bitDesno.update(idxD, Bj);
            ++pokazivac;
        }

        long long najbolje = INF;
        if(p - 1 >= 0){
            long long levo_min = bitLevo.upit(p);
            if(levo_min != INF){
                long long kandidat = visina_i + (levo_min + xs[p]);
                if(kandidat < najbolje) najbolje = kandidat;
            }
        }
        int duzina_desno = n - p - 1;
        if(duzina_desno > 0){
            long long desno_min = bitDesno.upit(duzina_desno);
            if(desno_min != INF){
                long long kandidat = visina_i + (desno_min - xs[p]);
                if(kandidat < najbolje) najbolje = kandidat;
            }
        }

        if(najbolje == INF) odg[orig_i] = -1;
        else {
            if(najbolje < 0) najbolje = 0;
            odg[orig_i] = najbolje;
        }
    }

    for(int i=0;i<n;++i){
        if(odg[i] < 0) cout << "-1\n"; else cout << odg[i] << "\n";
    }
    return 0;
}